unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls,
  { --- }
  USortuj;

const cMAX = 50;

type
  TMainForm = class(TForm)
    Memo1: TMemo;
    Memo2: TMemo;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    procedure BitBtn2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);

  private
    Tab : array[0..cMAX] of Integer;

  public
    procedure Start();
	 procedure Koniec();
    
  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TMainForm.BitBtn1Click(Sender: TObject);
begin
	Koniec();
end;

procedure TMainForm.BitBtn2Click(Sender: TObject);
begin
	Start();
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
	Memo1.Clear();
	Memo1.Align := alLeft;
	Memo2.Clear();
	Memo2.Align := alLeft;
end;

procedure TMainForm.Koniec();
begin
	if Application.MessageBox('Koniec pracy', 'Uwaga', MB_ICONINFORMATION or MB_YESNO) = mrYes then
	begin
		Close();
   end;
end;

procedure TMainForm.Start();
var
	lp  : Integer;
	max : Integer;

begin
	Memo1.Clear();
	Memo2.Clear();

	lp  := 0;
	max := 0;

   for lp := High(Tab) downto 0 do
   begin
   	Tab[lp] := max;
      max := max + 1;
   end;

	for lp := 0 to High(Tab) do
	begin
   	Memo1.Lines.Add(IntToStr(tab[lp]));
   end;

   QSort(Tab);

	for lp := 0 to High(Tab) do
	begin
   	Memo2.Lines.Add(IntToStr(tab[lp]));
   end;
end;

end.


